# TUBEROYIYO Web + Admin

Este paquete contiene el sitio en React **y** un panel de administración en **PHP**.

## Estructura
- `public/` y `src/` → código del sitio React (compila con `npm run build`)
- `admin/` → panel de administrador (PHP) con login y gestión de entradas/archivos
- `public_content/`
  - `data/posts.json` → listado del blog
  - `data/files.json` → listado de descargas
  - `uploads/` → ficheros subidos (con .htaccess para evitar ejecución)

## Flujo
1. **Compila** el sitio React:
   ```bash
   npm install
   npm run build
   ```
   Sube el contenido de `build/` a tu hosting (carpeta pública).

2. **Sube también** las carpetas `admin/` y `public_content/` al mismo nivel de `build/` en el servidor.
   Estructura en el servidor (ejemplo Apache):
   ```
   /var/www/html/            <- raíz pública
     ├─ build/               <- contenido del sitio (ponlo en raíz o mueve su contenido a la raíz)
     ├─ admin/               <- panel PHP
     └─ public_content/      <- datos y ficheros
   ```

3. **Configura credenciales** del admin en `admin/config.php`:
   - Usuario: `admin`
   - Password por defecto: `tuberoyiyo2025` → ¡CÁMBIALO!

4. **Acceso**: abre `https://tu-dominio.com/admin/login.php`.
   - Crea entradas en “Entradas del Blog” → se guardan en `public_content/data/posts.json`.
   - Sube archivos en “Gestión de Descargas” → se listan en `public_content/data/files.json` y se almacenan en `public_content/uploads/`.

5. **El frontend** (React) lee automáticamente:
   - Blog → `/public_content/data/posts.json`
   - Descargas → `/public_content/data/files.json`

> Si no quieres compilar React, puedes montar cualquier frontend y reutilizar el admin + `public_content/`.
