<?php
// admin/config.php
// *** Cambia estas credenciales ***
define('ADMIN_USER', 'admin');
// Password: tuberoyiyo2025  (cámbialo)
// Hash generado con password_hash('tuberoyiyo2025', PASSWORD_DEFAULT)
define('ADMIN_PASS_HASH', '$2y$10$qQqD3r2Aq9t8zJ2nUx6wSu1Xg2v2oGm4mYbSFiUG5Zr8xY3T2Nf9m');

// Rutas
define('BASE_DIR', realpath(__DIR__ . '/..'));
define('PUBLIC_CONTENT_DIR', BASE_DIR . '/public_content');
define('UPLOADS_DIR', PUBLIC_CONTENT_DIR . '/uploads');
define('DATA_DIR', PUBLIC_CONTENT_DIR . '/data');

// Crear carpetas si no existen
@mkdir(PUBLIC_CONTENT_DIR, 0775, true);
@mkdir(UPLOADS_DIR, 0775, true);
@mkdir(DATA_DIR, 0775, true);

// Archivos JSON
define('POSTS_JSON', DATA_DIR . '/posts.json');
define('FILES_JSON', DATA_DIR . '/files.json');

// Inicia sesión segura
if (session_status() === PHP_SESSION_NONE) {
  ini_set('session.cookie_httponly', 1);
  ini_set('session.use_strict_mode', 1);
  session_start();
}

// CSRF helpers
function csrf_token() {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf'];
}
function check_csrf() {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (empty($_POST['csrf']) || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $_POST['csrf'])) {
      http_response_code(403);
      exit('CSRF inválido');
    }
  }
}

// Carga/guarda JSON
function load_json($path, $fallback) {
  if (!file_exists($path)) return $fallback;
  $raw = file_get_contents($path);
  $data = json_decode($raw, true);
  return is_array($data) ? $data : $fallback;
}
function save_json($path, $arr) {
  file_put_contents($path, json_encode($arr, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
?>
