<?php
require_once __DIR__ . '/config.php';
if (empty($_SESSION['auth'])) { header('Location: /admin/login.php'); exit; }

$posts = load_json(POSTS_JSON, ["posts"=>[]]);
$files = load_json(FILES_JSON, ["files"=>[]]);
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard - Admin</title>
<style>
body{font-family:sans-serif;background:#f5f5f7;margin:0;padding:20px;color:#222}
header{display:flex;justify-content:space-between;align-items:center;margin-bottom:20px}
.card{background:#fff;border-radius:12px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:16px;margin-bottom:16px}
.grid{display:grid;gap:16px;grid-template-columns:repeat(auto-fit,minmax(240px,1fr))}
a.btn{display:inline-block;background:#1a73e8;color:#fff;padding:10px 14px;border-radius:8px;text-decoration:none}
nav a{margin-right:10px}
</style>
</head><body>
<header>
  <h1>Admin TUBEROYIYO</h1>
  <nav>
    <a class="btn" href="/admin/posts.php">Entradas del Blog</a>
    <a class="btn" href="/admin/files.php">Gestión de Descargas</a>
    <a class="btn" href="/admin/logout.php">Salir</a>
  </nav>
</header>

<div class="grid">
  <div class="card">
    <h2>Total Entradas</h2>
    <p><?=count($posts['posts'])?></p>
  </div>
  <div class="card">
    <h2>Archivos Publicados</h2>
    <p><?=count($files['files'])?></p>
  </div>
</div>
</body></html>
