<?php
require_once __DIR__ . '/config.php';
if (empty($_SESSION['auth'])) { header('Location: /admin/login.php'); exit; }
check_csrf();

$files = load_json(FILES_JSON, ["files"=>[]]);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
  // Upload file
  $f = $_FILES['file'];
  if ($f['error'] === UPLOAD_ERR_OK) {
    $name = basename($f['name']);
    $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    // Evitar ejecución de scripts
    $bad = ['php','phtml','phar','pl','py','cgi','jsp','asp','aspx','sh','exe'];
    if (in_array($ext, $bad)) { die('Tipo de archivo no permitido'); }

    $safe = time() . '_' . preg_replace('/[^A-Za-z0-9._-]/','_', $name);
    $dest = UPLOADS_DIR . '/' . $safe;
    if (move_uploaded_file($f['tmp_name'], $dest)) {
      $size = filesize($dest);
      $mime = mime_content_type($dest);
      $entry = [
        "id" => (string)time(),
        "name" => $name,
        "stored" => "/public_content/uploads/" . $safe,
        "size" => $size,
        "mime" => $mime,
        "date" => date('Y-m-d')
      ];
      $files['files'][] = $entry;
      save_json(FILES_JSON, $files);
    }
  }
}

// Delete file
if (isset($_POST['delete_id'])) {
  $del = $_POST['delete_id'];
  $files['files'] = array_values(array_filter($files['files'], function($e) use ($del) {
    return $e['id'] !== $del;
  }));
  save_json(FILES_JSON, $files);
}

$token = csrf_token();
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Gestión de Descargas</title>
<style>
body{font-family:sans-serif;background:#f5f5f7;margin:0;padding:20px}
header{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
.card{background:#fff;border-radius:12px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:16px;margin-bottom:16px}
input, select{padding:10px;border:1px solid #ddd;border-radius:8px}
.btn{background:#1a73e8;color:#fff;border:0;padding:10px 14px;border-radius:8px;cursor:pointer}
table{width:100%;border-collapse:collapse}
th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
</style>
</head><body>
<header>
  <h1>Gestión de Descargas</h1>
  <nav><a href="/admin/dashboard.php">Volver</a></nav>
</header>

<div class="card">
  <h2>Subir archivo</h2>
  <form method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?=htmlspecialchars($token)?>">
    <input type="file" name="file" required>
    <button class="btn" type="submit">Subir</button>
  </form>
  <p style="color:#666;margin-top:8px">Los archivos se guardan en <code>/public_content/uploads/</code> y se listan en <code>/public_content/data/files.json</code>.</p>
</div>

<div class="card">
  <h2>Archivos publicados</h2>
  <table>
    <thead><tr><th>Nombre</th><th>Fecha</th><th>Tamaño</th><th>Enlace</th><th>Acciones</th></tr></thead>
    <tbody>
    <?php
    foreach (array_reverse($files['files']) as $e) {
      $sizeKB = round($e['size']/1024,1) . ' KB';
      echo "<tr>
        <td>".htmlspecialchars($e['name'])."</td>
        <td>".htmlspecialchars($e['date'])."</td>
        <td>{$sizeKB}</td>
        <td><a href='{$e['stored']}' target='_blank' rel='noopener'>Descargar</a></td>
        <td>
          <form method='post' style='display:inline'>
            <input type='hidden' name='csrf' value='".htmlspecialchars($token)."'>
            <input type='hidden' name='delete_id' value='".htmlspecialchars($e['id'])."'>
            <button class='btn' style='background:#e11d48' onclick='return confirm("¿Eliminar?")'>Eliminar</button>
          </form>
        </td>
      </tr>";
    }
    ?>
    </tbody>
  </table>
</div>

</body></html>
