<?php
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  check_csrf();
  $u = $_POST['username'] ?? '';
  $p = $_POST['password'] ?? '';
  if ($u === ADMIN_USER && password_verify($p, ADMIN_PASS_HASH)) {
    $_SESSION['auth'] = true;
    header('Location: /admin/dashboard.php');
    exit;
  }
  $error = 'Credenciales incorrectas';
}
$token = csrf_token();
?>
<!doctype html>
<html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login Admin - TUBEROYIYO</title>
<style>
body{font-family:sans-serif;background:#f5f5f7;margin:0;padding:40px;color:#222}
.card{max-width:420px;margin:40px auto;background:#fff;border-radius:12px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:24px}
h1{margin:0 0 12px}
label{display:block;margin:12px 0 6px;font-size:14px}
input{width:100%;padding:10px;border:1px solid #ddd;border-radius:8px}
.btn{display:inline-block;padding:10px 14px;border:0;background:#1a73e8;color:#fff;border-radius:8px;margin-top:12px;cursor:pointer}
.err{color:#b00020;margin:8px 0}
</style>
</head><body>
<div class="card">
  <h1>Panel de administración</h1>
  <p>Ingresa tus credenciales</p>
  <?php if (!empty($error)) echo "<div class='err'>$error</div>"; ?>
  <form method="post">
    <input type="hidden" name="csrf" value="<?=htmlspecialchars($token)?>">
    <label>Usuario</label>
    <input name="username" autocomplete="username" required>
    <label>Contraseña</label>
    <input name="password" type="password" autocomplete="current-password" required>
    <button class="btn" type="submit">Entrar</button>
  </form>
</div>
</body></html>
