<?php
require_once __DIR__ . '/config.php';
if (empty($_SESSION['auth'])) { header('Location: /admin/login.php'); exit; }
check_csrf();

$posts = load_json(POSTS_JSON, ["posts"=>[]]);

// Handle create/update/delete
$action = $_POST['action'] ?? null;
if ($action === 'create' || $action === 'update') {
  $id = $_POST['id'] ?: (string)time();
  $title = trim($_POST['title'] ?? '');
  $excerpt = trim($_POST['excerpt'] ?? '');
  $content = trim($_POST['content'] ?? '');
  $date = $_POST['date'] ?: date('Y-m-d');

  $post = ["id"=>$id, "title"=>$title, "excerpt"=>$excerpt, "content"=>$content, "date"=>$date];
  $found = false;
  foreach ($posts['posts'] as &$p) {
    if ($p['id'] === $id) { $p = $post; $found=true; break; }
  }
  if (!$found) $posts['posts'][] = $post;
  save_json(POSTS_JSON, $posts);
}
if ($action === 'delete') {
  $id = $_POST['id'] ?? '';
  $posts['posts'] = array_values(array_filter($posts['posts'], fn($p)=>$p['id'] !== $id));
  save_json(POSTS_JSON, $posts);
}

$token = csrf_token();
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Entradas del Blog</title>
<style>
body{font-family:sans-serif;background:#f5f5f7;margin:0;padding:20px}
header{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
.card{background:#fff;border-radius:12px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:16px;margin-bottom:16px}
input, textarea{width:100%;padding:10px;border:1px solid #ddd;border-radius:8px}
label{display:block;margin:10px 0 6px}
.btn{background:#1a73e8;color:#fff;border:0;padding:10px 14px;border-radius:8px;cursor:pointer}
table{width:100%;border-collapse:collapse}
th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
</style>
</head><body>
<header>
  <h1>Entradas del Blog</h1>
  <nav><a href="/admin/dashboard.php">Volver</a></nav>
</header>

<div class="card">
  <h2>Nueva/Editar entrada</h2>
  <form method="post">
    <input type="hidden" name="csrf" value="<?=htmlspecialchars($token)?>">
    <input type="hidden" name="action" value="create">
    <input type="hidden" name="id" value="">
    <label>Título</label>
    <input name="title" required>
    <label>Resumen</label>
    <input name="excerpt">
    <label>Contenido</label>
    <textarea name="content" rows="6"></textarea>
    <label>Fecha</label>
    <input type="date" name="date" value="<?=date('Y-m-d')?>">
    <button class="btn" type="submit">Guardar</button>
  </form>
</div>

<div class="card">
  <h2>Listado</h2>
  <table>
    <thead><tr><th>Título</th><th>Fecha</th><th>Acciones</th></tr></thead>
    <tbody>
    <?php foreach (array_reverse($posts['posts']) as $p): ?>
      <tr>
        <td><?=htmlspecialchars($p['title'])?></td>
        <td><?=htmlspecialchars($p['date'])?></td>
        <td>
          <form method="post" style="display:inline">
            <input type="hidden" name="csrf" value="<?=htmlspecialchars($token)?>">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?=htmlspecialchars($p['id'])?>">
            <button class="btn" style="background:#e11d48" onclick="return confirm('¿Eliminar?')">Eliminar</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>

</body></html>
