import React from 'react';
import { Link } from 'react-router-dom';
import { motion } from 'framer-motion';
import { Wrench, Mail, Phone, MapPin } from 'lucide-react';

const Footer = () => {
  const quickLinks = [
    { name: 'Inicio', href: '/' },
    { name: 'Descargas', href: '/descargas' },
    { name: 'Blog', href: '/blog' },
    { name: 'Privacidad', href: '/privacidad' },
    { name: 'Términos', href: '/terminos' },
    { name: 'Contacto', href: '/contacto' }
  ];

  return (
    <footer className="bg-gray-900 text-white">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {/* Brand Section */}
          <div className="space-y-4">
            <div className="flex items-center gap-3">
              <div className="p-2 bg-gradient-to-br from-blue-600 to-blue-700 rounded-xl">
                <Wrench className="w-6 h-6 text-white" />
              </div>
              <span className="text-2xl font-bold">TUBEROYIYO</span>
            </div>
            <p className="text-gray-400 leading-relaxed">
              La aplicación más avanzada para el cálculo y trazado de tuberías. 
              Herramientas profesionales para ingenieros y técnicos.
            </p>
            <div className="flex gap-4">
              <motion.a
                href="https://play.google.com"
                target="_blank"
                rel="noopener noreferrer"
                className="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 px-4 py-2 rounded-lg font-medium transition-colors"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              >
                Descargar App
              </motion.a>
            </div>
          </div>

          {/* Quick Links */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold">Enlaces Rápidos</h3>
            <div className="grid grid-cols-2 gap-2">
              {quickLinks.map((link) => (
                <Link
                  key={link.name}
                  to={link.href}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  {link.name}
                </Link>
              ))}
            </div>
          </div>

          {/* Contact Info */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold">Contacto</h3>
            <div className="space-y-3">
              <div className="flex items-center gap-3 text-gray-400">
                <Mail className="w-5 h-5" />
                <span>info@tuberoyiyo.com</span>
              </div>
              <div className="flex items-center gap-3 text-gray-400">
                <Phone className="w-5 h-5" />
                <span>+34 900 123 456</span>
              </div>
              <div className="flex items-center gap-3 text-gray-400">
                <MapPin className="w-5 h-5" />
                <span>Madrid, España</span>
              </div>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-gray-800 mt-8 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
          <p className="text-gray-400 text-sm">
            © 2025 TUBEROYIYO. Todos los derechos reservados.
          </p>
          <div className="flex gap-6 text-sm">
            <Link to="/privacidad" className="text-gray-400 hover:text-white transition-colors">
              Política de Privacidad
            </Link>
            <Link to="/terminos" className="text-gray-400 hover:text-white transition-colors">
              Términos de Uso
            </Link>
          </div>
        </div>
      </div>

      {/* Google Analytics Placeholder */}
      <div id="google-analytics-footer"></div>
    </footer>
  );
};

export default Footer;