import React, { useState } from 'react';
import { motion, AnimatePresence } from 'framer-motion';
import { 
  Lock, 
  User, 
  Eye, 
  EyeOff, 
  Shield, 
  Upload, 
  FileText, 
  Image, 
  Edit3, 
  Trash2, 
  Plus,
  Save,
  LogOut,
  BarChart3
} from 'lucide-react';

const Admin = () => {
  const [isAuthenticated, setIsAuthenticated] = useState(false);
  const [loginData, setLoginData] = useState({ username: '', password: '' });
  const [showPassword, setShowPassword] = useState(false);
  const [activeTab, setActiveTab] = useState('dashboard');
  const [loginError, setLoginError] = useState('');

  // Mock data
  const [downloads, setDownloads] = useState([
    { id: 1, name: 'Manual Usuario v2.1', type: 'pdf', size: '2.5 MB', downloads: 1250 },
    { id: 2, name: 'Tabla Pérdidas Carga', type: 'pdf', size: '850 KB', downloads: 890 }
  ]);

  const [blogPosts, setBlogPosts] = useState([
    { id: 1, title: 'Cálculo de Pérdidas de Carga', status: 'published', date: '2025-01-15' },
    { id: 2, title: 'Nuevas Funcionalidades v2.1', status: 'draft', date: '2025-01-12' }
  ]);

  const [galleryImages, setGalleryImages] = useState([
    { id: 1, name: 'Interfaz Principal', alt: 'Interfaz principal TUBEROYIYO' },
    { id: 2, name: 'Módulo Cálculos', alt: 'Módulo de cálculos' }
  ]);

  const handleLogin = (e) => {
    e.preventDefault();
    // Simulación de autenticación (en producción usar autenticación real)
    if (loginData.username === 'admin' && loginData.password === 'tuberoyiyo2025') {
      setIsAuthenticated(true);
      setLoginError('');
    } else {
      setLoginError('Credenciales incorrectas');
    }
  };

  const handleLogout = () => {
    setIsAuthenticated(false);
    setLoginData({ username: '', password: '' });
    setActiveTab('dashboard');
  };

  const tabs = [
    { id: 'dashboard', label: 'Dashboard', icon: BarChart3 },
    { id: 'downloads', label: 'Descargas', icon: FileText },
    { id: 'blog', label: 'Blog', icon: Edit3 },
    { id: 'gallery', label: 'Galería', icon: Image },
    { id: 'settings', label: 'Configuración', icon: Shield }
  ];

  if (!isAuthenticated) {
    return (
      <div className="min-h-screen bg-gradient-to-br from-gray-900 via-blue-900 to-purple-900 flex items-center justify-center p-4">
        <motion.div 
          className="bg-white/95 backdrop-blur-xl rounded-3xl p-8 w-full max-w-md shadow-2xl border border-white/20"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8 }}
        >
          <div className="text-center mb-8">
            <div className="p-4 bg-gradient-to-br from-blue-600 to-purple-600 rounded-2xl w-fit mx-auto mb-4">
              <Shield className="w-8 h-8 text-white" />
            </div>
            <h1 className="text-3xl font-bold text-gray-900 mb-2">Panel de Administrador</h1>
            <p className="text-gray-600">Acceso restringido - TUBEROYIYO</p>
          </div>

          <form onSubmit={handleLogin} className="space-y-6">
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-2">
                Usuario
              </label>
              <div className="relative">
                <User className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" />
                <input
                  type="text"
                  value={loginData.username}
                  onChange={(e) => setLoginData({...loginData, username: e.target.value})}
                  className="w-full pl-10 pr-4 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/30 focus:border-blue-500"
                  placeholder="Nombre de usuario"
                  required
                />
              </div>
            </div>

            <div>
              <label className="block text-sm font-medium text-gray-700 mb-2">
                Contraseña
              </label>
              <div className="relative">
                <Lock className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 w-5 h-5" />
                <input
                  type={showPassword ? 'text' : 'password'}
                  value={loginData.password}
                  onChange={(e) => setLoginData({...loginData, password: e.target.value})}
                  className="w-full pl-10 pr-12 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/30 focus:border-blue-500"
                  placeholder="Contraseña"
                  required
                />
                <button
                  type="button"
                  onClick={() => setShowPassword(!showPassword)}
                  className="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600"
                >
                  {showPassword ? <EyeOff className="w-5 h-5" /> : <Eye className="w-5 h-5" />}
                </button>
              </div>
            </div>

            {loginError && (
              <motion.div 
                className="bg-red-50 border border-red-200 rounded-xl p-3 text-red-700 text-sm"
                initial={{ opacity: 0 }}
                animate={{ opacity: 1 }}
              >
                {loginError}
              </motion.div>
            )}

            <motion.button
              type="submit"
              className="w-full bg-gradient-to-r from-blue-600 to-purple-600 text-white py-3 rounded-xl font-semibold shadow-lg hover:shadow-xl transition-all duration-300"
              whileHover={{ scale: 1.02 }}
              whileTap={{ scale: 0.98 }}
            >
              Iniciar Sesión
            </motion.button>
          </form>

          <div className="mt-6 text-center text-xs text-gray-500">
            Demo: admin / tuberoyiyo2025
          </div>
        </motion.div>
      </div>
    );
  }

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Header */}
      <header className="bg-white border-b border-gray-200 px-6 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3">
            <div className="p-2 bg-gradient-to-br from-blue-600 to-purple-600 rounded-xl">
              <Shield className="w-6 h-6 text-white" />
            </div>
            <div>
              <h1 className="text-xl font-bold text-gray-900">Panel de Administrador</h1>
              <p className="text-sm text-gray-500">TUBEROYIYO - Gestión de contenidos</p>
            </div>
          </div>
          <motion.button
            onClick={handleLogout}
            className="flex items-center gap-2 px-4 py-2 bg-red-100 text-red-700 rounded-xl hover:bg-red-200 transition-colors"
            whileHover={{ scale: 1.05 }}
            whileTap={{ scale: 0.95 }}
          >
            <LogOut className="w-4 h-4" />
            Cerrar Sesión
          </motion.button>
        </div>
      </header>

      <div className="flex">
        {/* Sidebar */}
        <nav className="w-64 bg-white border-r border-gray-200 min-h-screen p-6">
          <div className="space-y-2">
            {tabs.map((tab) => (
              <motion.button
                key={tab.id}
                onClick={() => setActiveTab(tab.id)}
                className={`w-full flex items-center gap-3 px-4 py-3 rounded-xl font-medium transition-all duration-300 ${
                  activeTab === tab.id
                    ? 'bg-blue-100 text-blue-700'
                    : 'text-gray-600 hover:bg-gray-100'
                }`}
                whileHover={{ x: 5 }}
              >
                <tab.icon className="w-5 h-5" />
                {tab.label}
              </motion.button>
            ))}
          </div>
        </nav>

        {/* Main Content */}
        <main className="flex-1 p-6">
          <AnimatePresence mode="wait">
            {activeTab === 'dashboard' && (
              <motion.div
                key="dashboard"
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                exit={{ opacity: 0, y: -20 }}
                className="space-y-6"
              >
                <h2 className="text-2xl font-bold text-gray-900">Dashboard</h2>
                
                <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
                  <div className="bg-white rounded-2xl p-6 shadow-sm border border-gray-200">
                    <div className="flex items-center gap-3 mb-4">
                      <div className="p-2 bg-blue-100 rounded-lg">
                        <FileText className="w-5 h-5 text-blue-600" />
                      </div>
                      <h3 className="font-semibold text-gray-900">Descargas</h3>
                    </div>
                    <p className="text-3xl font-bold text-gray-900">{downloads.length}</p>
                    <p className="text-sm text-gray-500">Archivos disponibles</p>
                  </div>

                  <div className="bg-white rounded-2xl p-6 shadow-sm border border-gray-200">
                    <div className="flex items-center gap-3 mb-4">
                      <div className="p-2 bg-green-100 rounded-lg">
                        <Edit3 className="w-5 h-5 text-green-600" />
                      </div>
                      <h3 className="font-semibold text-gray-900">Blog</h3>
                    </div>
                    <p className="text-3xl font-bold text-gray-900">{blogPosts.length}</p>
                    <p className="text-sm text-gray-500">Artículos publicados</p>
                  </div>

                  <div className="bg-white rounded-2xl p-6 shadow-sm border border-gray-200">
                    <div className="flex items-center gap-3 mb-4">
                      <div className="p-2 bg-purple-100 rounded-lg">
                        <Image className="w-5 h-5 text-purple-600" />
                      </div>
                      <h3 className="font-semibold text-gray-900">Galería</h3>
                    </div>
                    <p className="text-3xl font-bold text-gray-900">{galleryImages.length}</p>
                    <p className="text-sm text-gray-500">Imágenes subidas</p>
                  </div>
                </div>
              </motion.div>
            )}

            {activeTab === 'downloads' && (
              <motion.div
                key="downloads"
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                exit={{ opacity: 0, y: -20 }}
                className="space-y-6"
              >
                <div className="flex items-center justify-between">
                  <h2 className="text-2xl font-bold text-gray-900">Gestión de Descargas</h2>
                  <motion.button
                    className="flex items-center gap-2 bg-blue-600 text-white px-4 py-2 rounded-xl hover:bg-blue-700 transition-colors"
                    whileHover={{ scale: 1.05 }}
                    whileTap={{ scale: 0.95 }}
                  >
                    <Plus className="w-4 h-4" />
                    Subir Archivo
                  </motion.button>
                </div>

                <div className="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
                  <div className="overflow-x-auto">
                    <table className="w-full">
                      <thead className="bg-gray-50 border-b border-gray-200">
                        <tr>
                          <th className="text-left px-6 py-4 font-semibold text-gray-900">Archivo</th>
                          <th className="text-left px-6 py-4 font-semibold text-gray-900">Tipo</th>
                          <th className="text-left px-6 py-4 font-semibold text-gray-900">Tamaño</th>
                          <th className="text-left px-6 py-4 font-semibold text-gray-900">Descargas</th>
                          <th className="text-left px-6 py-4 font-semibold text-gray-900">Acciones</th>
                        </tr>
                      </thead>
                      <tbody>
                        {downloads.map((file) => (
                          <tr key={file.id} className="border-b border-gray-100 hover:bg-gray-50">
                            <td className="px-6 py-4 font-medium text-gray-900">{file.name}</td>
                            <td className="px-6 py-4 text-gray-600">{file.type.toUpperCase()}</td>
                            <td className="px-6 py-4 text-gray-600">{file.size}</td>
                            <td className="px-6 py-4 text-gray-600">{file.downloads}</td>
                            <td className="px-6 py-4">
                              <div className="flex gap-2">
                                <button className="p-2 text-blue-600 hover:bg-blue-100 rounded-lg transition-colors">
                                  <Edit3 className="w-4 h-4" />
                                </button>
                                <button className="p-2 text-red-600 hover:bg-red-100 rounded-lg transition-colors">
                                  <Trash2 className="w-4 h-4" />
                                </button>
                              </div>
                            </td>
                          </tr>
                        ))}
                      </tbody>
                    </table>
                  </div>
                </div>
              </motion.div>
            )}

            {/* Otros tabs similares... */}
          </AnimatePresence>
        </main>
      </div>
    </div>
  );
};

export default Admin;