import React from 'react';
import { motion } from 'framer-motion';
import { Download, FileText, Calculator, Ruler, Star, CheckCircle, Smartphone, Users } from 'lucide-react';

const Home = () => {
  const features = [
    {
      icon: Calculator,
      title: 'Cálculos Precisos',
      description: 'Algoritmos avanzados para cálculos hidráulicos y dimensionamiento de tuberías'
    },
    {
      icon: Ruler,
      title: 'Trazado Profesional',
      description: 'Herramientas de diseño para crear planos técnicos detallados'
    },
    {
      icon: FileText,
      title: 'Documentación Completa',
      description: 'Genera informes técnicos y documentación automáticamente'
    },
    {
      icon: Smartphone,
      title: 'Multiplataforma',
      description: 'Disponible en Android con sincronización en la nube'
    }
  ];

  const testimonials = [
    {
      name: 'Carlos Rodríguez',
      role: 'Ingeniero Industrial',
      content: 'TUBEROYIYO ha revolucionado mi trabajo diario. Los cálculos son precisos y el interfaz es muy intuitivo.',
      rating: 5
    },
    {
      name: 'María González',
      role: 'Técnico en Instalaciones',
      content: 'Una herramienta imprescindible para cualquier profesional del sector. Ahorra tiempo y evita errores.',
      rating: 5
    },
    {
      name: 'Antonio López',
      role: 'Jefe de Proyecto',
      content: 'La mejor aplicación para cálculo de tuberías que he usado. Muy recomendable para equipos técnicos.',
      rating: 5
    }
  ];

  const galleryImages = [
    { id: 1, alt: 'Interfaz principal de TUBEROYIYO', src: 'https://via.placeholder.com/400x300/3B82F6/FFFFFF?text=Interfaz+Principal' },
    { id: 2, alt: 'Módulo de cálculos', src: 'https://via.placeholder.com/400x300/1E40AF/FFFFFF?text=Modulo+Calculos' },
    { id: 3, alt: 'Herramientas de trazado', src: 'https://via.placeholder.com/400x300/2563EB/FFFFFF?text=Herramientas+Trazado' },
    { id: 4, alt: 'Reportes generados', src: 'https://via.placeholder.com/400x300/1D4ED8/FFFFFF?text=Reportes+Generados' }
  ];

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-20">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-4xl mx-auto">
            <motion.h1 
              className="text-5xl md:text-6xl font-bold mb-6 bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8 }}
            >
              TUBEROYIYO
            </motion.h1>
            
            <motion.p 
              className="text-xl md:text-2xl text-gray-600 mb-8 leading-relaxed"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8, delay: 0.2 }}
            >
              La aplicación más avanzada para el <strong>cálculo y trazado de tuberías</strong>. 
              Herramientas profesionales para ingenieros y técnicos.
            </motion.p>

            <motion.div 
              className="flex flex-col sm:flex-row gap-4 justify-center items-center"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8, delay: 0.4 }}
            >
              <motion.a
                href="https://play.google.com"
                target="_blank"
                rel="noopener noreferrer"
                className="inline-flex items-center gap-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white px-8 py-4 rounded-2xl font-semibold text-lg shadow-lg hover:shadow-xl transition-all duration-300"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              >
                <Download className="w-6 h-6" />
                Descargar en Google Play
              </motion.a>

              <motion.a
                href="/descargas"
                className="inline-flex items-center gap-3 bg-white text-blue-600 px-8 py-4 rounded-2xl font-semibold text-lg border-2 border-blue-200 hover:border-blue-300 transition-all duration-300"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              >
                <FileText className="w-6 h-6" />
                Documentos y Descargas
              </motion.a>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Características Técnicas</h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              Herramientas profesionales diseñadas para optimizar tu trabajo en el diseño y cálculo de instalaciones
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {features.map((feature, index) => (
              <motion.div
                key={feature.title}
                className="bg-white border border-gray-200 rounded-2xl p-6 shadow-sm hover:shadow-lg transition-all duration-300"
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                whileHover={{ y: -5 }}
              >
                <div className="p-3 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl w-fit mb-4">
                  <feature.icon className="w-6 h-6 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-gray-900 mb-3">{feature.title}</h3>
                <p className="text-gray-600 leading-relaxed">{feature.description}</p>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Gallery Section */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Galería de Imágenes</h2>
            <p className="text-xl text-gray-600">
              Descubre la interfaz y funcionalidades de TUBEROYIYO
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {galleryImages.map((image, index) => (
              <motion.div
                key={image.id}
                className="bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-lg transition-all duration-300"
                initial={{ opacity: 0, scale: 0.9 }}
                animate={{ opacity: 1, scale: 1 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                whileHover={{ scale: 1.05 }}
              >
                <img
                  src={image.src}
                  alt={image.alt}
                  className="w-full h-48 object-cover"
                />
                <div className="p-4">
                  <p className="text-gray-600 text-sm">{image.alt}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Lo que dicen nuestros usuarios</h2>
            <p className="text-xl text-gray-600">
              Testimonios reales de profesionales que confían en TUBEROYIYO
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            {testimonials.map((testimonial, index) => (
              <motion.div
                key={testimonial.name}
                className="bg-gradient-to-br from-blue-50 to-indigo-50 border border-blue-200 rounded-2xl p-6"
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
              >
                <div className="flex gap-1 mb-4">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 text-yellow-400 fill-current" />
                  ))}
                </div>
                <p className="text-gray-700 mb-4 italic">"{testimonial.content}"</p>
                <div>
                  <p className="font-semibold text-gray-900">{testimonial.name}</p>
                  <p className="text-blue-600 text-sm">{testimonial.role}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-blue-600 to-purple-600">
        <div className="container mx-auto px-4 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8 }}
          >
            <h2 className="text-4xl font-bold text-white mb-6">
              ¿Listo para optimizar tu trabajo?
            </h2>
            <p className="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
              Únete a miles de profesionales que ya utilizan TUBEROYIYO para sus proyectos
            </p>
            <motion.a
              href="https://play.google.com"
              target="_blank"
              rel="noopener noreferrer"
              className="inline-flex items-center gap-3 bg-white text-blue-600 px-8 py-4 rounded-2xl font-semibold text-lg shadow-lg hover:shadow-xl transition-all duration-300"
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
            >
              <Download className="w-6 h-6" />
              Descargar Ahora Gratis
            </motion.a>
          </motion.div>
        </div>
      </section>
    </div>
  );
};

export default Home;