import React from 'react';
import { motion } from 'framer-motion';
import { Shield, Eye, Lock, Database, Users, Mail } from 'lucide-react';

const Privacy = () => {
  const sections = [
    {
      icon: Database,
      title: 'Información que Recopilamos',
      content: [
        'Información de cuenta: nombre, email y datos de registro',
        'Datos de uso: cómo utilizas la aplicación y sus funcionalidades',
        'Información técnica: tipo de dispositivo, sistema operativo, versión de la app',
        'Datos de proyectos: cálculos y diseños creados en la aplicación (almacenados localmente)'
      ]
    },
    {
      icon: Eye,
      title: 'Cómo Utilizamos tu Información',
      content: [
        'Proporcionar y mejorar nuestros servicios',
        'Personalizar tu experiencia de usuario',
        'Comunicarnos contigo sobre actualizaciones y novedades',
        'Analizar el uso de la aplicación para mejoras futuras',
        'Cumplir con obligaciones legales y regulatorias'
      ]
    },
    {
      icon: Lock,
      title: 'Protección de Datos',
      content: [
        'Utilizamos encriptación SSL/TLS para proteger la transmisión de datos',
        'Los datos se almacenan en servidores seguros con acceso restringido',
        'Implementamos medidas de seguridad técnicas y organizativas',
        'Realizamos auditorías regulares de seguridad',
        'El acceso a datos personales está limitado al personal autorizado'
      ]
    },
    {
      icon: Users,
      title: 'Compartir Información',
      content: [
        'No vendemos ni alquilamos tu información personal a terceros',
        'Podemos compartir datos con proveedores de servicios de confianza',
        'Cumplimos con solicitudes legales cuando sea requerido por ley',
        'En caso de fusión o adquisición, los datos pueden transferirse',
        'Siempre con las debidas garantías de protección'
      ]
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50 py-12">
      <div className="container mx-auto px-4 max-w-4xl">
        {/* Header */}
        <motion.div 
          className="text-center mb-12"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8 }}
        >
          <div className="flex items-center justify-center gap-3 mb-6">
            <div className="p-3 bg-gradient-to-br from-blue-600 to-blue-700 rounded-xl">
              <Shield className="w-8 h-8 text-white" />
            </div>
            <h1 className="text-4xl font-bold text-gray-900">
              Política de Privacidad
            </h1>
          </div>
          <p className="text-xl text-gray-600">
            En TUBEROYIYO, tu privacidad es nuestra prioridad. Esta política explica cómo recopilamos, 
            utilizamos y protegemos tu información personal.
          </p>
          <div className="mt-4 text-sm text-gray-500">
            Última actualización: 15 de enero de 2025
          </div>
        </motion.div>

        {/* Introduction */}
        <motion.div 
          className="bg-white rounded-2xl p-8 mb-8 shadow-sm border border-gray-200"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.2 }}
        >
          <h2 className="text-2xl font-bold text-gray-900 mb-4">Introducción</h2>
          <p className="text-gray-600 leading-relaxed mb-4">
            TUBEROYIYO ("nosotros", "nuestro" o "la aplicación") se compromete a proteger y respetar tu privacidad. 
            Esta Política de Privacidad explica cómo recopilamos, utilizamos, divulgamos y protegemos tu información 
            cuando utilizas nuestra aplicación móvil y servicios relacionados.
          </p>
          <p className="text-gray-600 leading-relaxed">
            Al utilizar TUBEROYIYO, aceptas las prácticas descritas en esta política. Si no estás de acuerdo con 
            algún aspecto de esta política, te recomendamos que no utilices nuestra aplicación.
          </p>
        </motion.div>

        {/* Main Sections */}
        <div className="space-y-6">
          {sections.map((section, index) => (
            <motion.div
              key={section.title}
              className="bg-white rounded-2xl p-8 shadow-sm border border-gray-200"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: 0.3 + index * 0.1 }}
            >
              <div className="flex items-start gap-4 mb-6">
                <div className="p-3 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl">
                  <section.icon className="w-6 h-6 text-white" />
                </div>
                <h2 className="text-2xl font-bold text-gray-900">{section.title}</h2>
              </div>
              <ul className="space-y-3">
                {section.content.map((item, itemIndex) => (
                  <li key={itemIndex} className="flex items-start gap-3">
                    <div className="w-2 h-2 bg-blue-600 rounded-full mt-2 flex-shrink-0"></div>
                    <span className="text-gray-600 leading-relaxed">{item}</span>
                  </li>
                ))}
              </ul>
            </motion.div>
          ))}
        </div>

        {/* Rights Section */}
        <motion.div 
          className="bg-gradient-to-br from-blue-50 to-indigo-50 border border-blue-200 rounded-2xl p-8 mt-8"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.8 }}
        >
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Tus Derechos</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <h3 className="font-semibold text-gray-900 mb-3">Derechos GDPR</h3>
              <ul className="space-y-2 text-gray-600">
                <li>• Derecho de acceso a tus datos</li>
                <li>• Derecho de rectificación</li>
                <li>• Derecho de supresión</li>
                <li>• Derecho a la portabilidad</li>
                <li>• Derecho de oposición</li>
              </ul>
            </div>
            <div>
              <h3 className="font-semibold text-gray-900 mb-3">Cómo Ejercer tus Derechos</h3>
              <ul className="space-y-2 text-gray-600">
                <li>• Contacta con nosotros por email</li>
                <li>• Proporciona identificación válida</li>
                <li>• Especifica claramente tu solicitud</li>
                <li>• Responderemos en 30 días máximo</li>
              </ul>
            </div>
          </div>
        </motion.div>

        {/* Contact Section */}
        <motion.div 
          className="bg-white rounded-2xl p-8 mt-8 shadow-sm border border-gray-200"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.9 }}
        >
          <div className="flex items-start gap-4 mb-6">
            <div className="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-xl">
              <Mail className="w-6 h-6 text-white" />
            </div>
            <div>
              <h2 className="text-2xl font-bold text-gray-900 mb-2">Contacto</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                Si tienes preguntas sobre esta Política de Privacidad o deseas ejercer alguno de tus derechos, 
                no dudes en contactarnos:
              </p>
              <div className="space-y-2 text-gray-600">
                <p><strong>Email:</strong> privacidad@tuberoyiyo.com</p>
                <p><strong>Dirección:</strong> Madrid, España</p>
                <p><strong>Teléfono:</strong> +34 900 123 456</p>
              </div>
            </div>
          </div>
        </motion.div>

        {/* Updates Notice */}
        <motion.div 
          className="bg-yellow-50 border border-yellow-200 rounded-2xl p-6 mt-8"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 1.0 }}
        >
          <h3 className="font-semibold text-yellow-800 mb-2">Actualizaciones de la Política</h3>
          <p className="text-yellow-700 text-sm">
            Nos reservamos el derecho de actualizar esta Política de Privacidad ocasionalmente. 
            Te notificaremos sobre cambios significativos a través de la aplicación o por email. 
            Te recomendamos revisar esta página periódicamente para estar al tanto de cualquier cambio.
          </p>
        </motion.div>
      </div>
    </div>
  );
};

export default Privacy;