import React from 'react';
import { motion } from 'framer-motion';
import { FileText, AlertTriangle, Scale, Users, Shield, Gavel } from 'lucide-react';

const Terms = () => {
  const sections = [
    {
      icon: Users,
      title: 'Aceptación de los Términos',
      content: [
        'Al descargar, instalar o utilizar TUBEROYIYO, aceptas estos términos y condiciones',
        'Si no estás de acuerdo con algún término, no utilices la aplicación',
        'Estos términos constituyen un acuerdo legal entre tú y TUBEROYIYO',
        'Debes tener al menos 18 años o contar con autorización parental para usar la app'
      ]
    },
    {
      icon: Shield,
      title: 'Uso Permitido',
      content: [
        'La aplicación está destinada exclusivamente para uso profesional y educativo',
        'Puedes utilizar TUBEROYIYO para cálculos y diseños de sistemas de tuberías',
        'Está prohibido el uso comercial sin licencia apropiada',
        'No puedes modificar, descompilar o realizar ingeniería inversa de la aplicación',
        'Respeta los derechos de propiedad intelectual en todo momento'
      ]
    },
    {
      icon: AlertTriangle,
      title: 'Limitaciones y Responsabilidades',
      content: [
        'TUBEROYIYO se proporciona "tal como está" sin garantías de ningún tipo',
        'No garantizamos que la aplicación esté libre de errores o interrupciones',
        'El usuario es responsable de verificar todos los cálculos y resultados',
        'No nos hacemos responsables de daños derivados del uso de la aplicación',
        'Los resultados deben ser validados por profesionales cualificados'
      ]
    },
    {
      icon: Scale,
      title: 'Propiedad Intelectual',
      content: [
        'TUBEROYIYO y todo su contenido están protegidos por derechos de autor',
        'Las marcas comerciales y logos son propiedad de sus respectivos dueños',
        'No puedes copiar, distribuir o crear obras derivadas sin autorización',
        'Los datos que ingreses permanecen bajo tu propiedad',
        'Respetamos la propiedad intelectual de terceros'
      ]
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50 py-12">
      <div className="container mx-auto px-4 max-w-4xl">
        {/* Header */}
        <motion.div 
          className="text-center mb-12"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8 }}
        >
          <div className="flex items-center justify-center gap-3 mb-6">
            <div className="p-3 bg-gradient-to-br from-purple-600 to-purple-700 rounded-xl">
              <Gavel className="w-8 h-8 text-white" />
            </div>
            <h1 className="text-4xl font-bold text-gray-900">
              Términos y Condiciones
            </h1>
          </div>
          <p className="text-xl text-gray-600">
            Estos términos y condiciones rigen el uso de la aplicación TUBEROYIYO y establecen 
            los derechos y obligaciones entre los usuarios y nuestra plataforma.
          </p>
          <div className="mt-4 text-sm text-gray-500">
            Última actualización: 15 de enero de 2025
          </div>
        </motion.div>

        {/* Introduction */}
        <motion.div 
          className="bg-white rounded-2xl p-8 mb-8 shadow-sm border border-gray-200"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.2 }}
        >
          <h2 className="text-2xl font-bold text-gray-900 mb-4">Introducción</h2>
          <p className="text-gray-600 leading-relaxed mb-4">
            Bienvenido a TUBEROYIYO, una aplicación especializada en cálculo y trazado de tuberías para 
            profesionales de la ingeniería y técnicos especializados. Estos Términos y Condiciones 
            ("Términos") rigen tu acceso y uso de nuestra aplicación móvil y servicios relacionados.
          </p>
          <p className="text-gray-600 leading-relaxed">
            Al utilizar TUBEROYIYO, confirmas que has leído, entendido y aceptado estar sujeto a estos 
            Términos. Si actúas en nombre de una organización, declaras tener autoridad para vincular 
            a dicha organización a estos Términos.
          </p>
        </motion.div>

        {/* Main Sections */}
        <div className="space-y-6">
          {sections.map((section, index) => (
            <motion.div
              key={section.title}
              className="bg-white rounded-2xl p-8 shadow-sm border border-gray-200"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: 0.3 + index * 0.1 }}
            >
              <div className="flex items-start gap-4 mb-6">
                <div className="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl">
                  <section.icon className="w-6 h-6 text-white" />
                </div>
                <h2 className="text-2xl font-bold text-gray-900">{section.title}</h2>
              </div>
              <ul className="space-y-3">
                {section.content.map((item, itemIndex) => (
                  <li key={itemIndex} className="flex items-start gap-3">
                    <div className="w-2 h-2 bg-purple-600 rounded-full mt-2 flex-shrink-0"></div>
                    <span className="text-gray-600 leading-relaxed">{item}</span>
                  </li>
                ))}
              </ul>
            </motion.div>
          ))}
        </div>

        {/* Professional Use Notice */}
        <motion.div 
          className="bg-gradient-to-br from-amber-50 to-orange-50 border border-amber-200 rounded-2xl p-8 mt-8"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.8 }}
        >
          <div className="flex items-start gap-4">
            <AlertTriangle className="w-8 h-8 text-amber-600 flex-shrink-0 mt-1" />
            <div>
              <h2 className="text-2xl font-bold text-amber-800 mb-4">Aviso Importante para Uso Profesional</h2>
              <div className="space-y-4 text-amber-700">
                <p className="leading-relaxed">
                  <strong>TUBEROYIYO es una herramienta de apoyo para profesionales.</strong> Todos los cálculos, 
                  diseños y resultados generados por la aplicación deben ser revisados y validados por ingenieros 
                  cualificados antes de su implementación en proyectos reales.
                </p>
                <p className="leading-relaxed">
                  La aplicación no sustituye el criterio profesional, el conocimiento técnico especializado, 
                  ni el cumplimiento de normativas locales y códigos técnicos aplicables en cada jurisdicción.
                </p>
                <p className="leading-relaxed">
                  <strong>Recomendación:</strong> Utiliza TUBEROYIYO como complemento a tu experiencia profesional 
                  y siempre verifica los resultados con métodos alternativos cuando sea crítico para la seguridad.
                </p>
              </div>
            </div>
          </div>
        </motion.div>

        {/* Updates and Modifications */}
        <motion.div 
          className="bg-white rounded-2xl p-8 mt-8 shadow-sm border border-gray-200"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.9 }}
        >
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Modificaciones y Actualizaciones</h2>
          <div className="space-y-4 text-gray-600">
            <p className="leading-relaxed">
              Nos reservamos el derecho de modificar estos Términos y Condiciones en cualquier momento. 
              Las modificaciones entrarán en vigor inmediatamente después de su publicación en la aplicación 
              o en nuestro sitio web.
            </p>
            <p className="leading-relaxed">
              Te notificaremos sobre cambios significativos a través de la aplicación, email o mediante 
              un aviso prominente en nuestros servicios. Tu uso continuado de TUBEROYIYO después de 
              dichas modificaciones constituye tu aceptación de los nuevos términos.
            </p>
            <p className="leading-relaxed">
              Si no estás de acuerdo con las modificaciones, debes dejar de utilizar la aplicación 
              inmediatamente.
            </p>
          </div>
        </motion.div>

        {/* Contact and Legal */}
        <motion.div 
          className="bg-gray-900 text-white rounded-2xl p-8 mt-8"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 1.0 }}
        >
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
              <h3 className="text-xl font-bold mb-4">Información Legal</h3>
              <div className="space-y-2 text-gray-300">
                <p><strong>Empresa:</strong> TUBEROYIYO S.L.</p>
                <p><strong>Domicilio:</strong> Madrid, España</p>
                <p><strong>Email:</strong> legal@tuberoyiyo.com</p>
                <p><strong>Jurisdicción:</strong> Tribunales de Madrid</p>
              </div>
            </div>
            <div>
              <h3 className="text-xl font-bold mb-4">Resolución de Disputas</h3>
              <p className="text-gray-300 leading-relaxed">
                Cualquier disputa relacionada con estos términos se resolverá mediante arbitraje 
                vinculante bajo las leyes españolas. Ambas partes renuncian al derecho a un juicio 
                por jurado para cualquier disputa relacionada con estos términos.
              </p>
            </div>
          </div>
        </motion.div>
      </div>
    </div>
  );
};

export default Terms;